///////////////////////////////////////////////////////////////////////
// Code for user selected modes
///////////////////////////////////////////////////////////////////////
// this section need to be fleshed ouot further. Feel free to have a
// go at developing these and modes of your own. The ESP32 provides
// plenty of code space for this.

// --------------------------------------------------------------------------------

void MainAutoTask() {
  ///////////////////////////////////////////////////////////////////////
  // AUTONOMOUS mode
  ///////////////////////////////////////////////////////////////////////
  // move around using the LTOF sensor, responding to static objects
}

// --------------------------------------------------------------------------------

void MainPilotTask() {
  ///////////////////////////////////////////////////////////////////////
  // PILOT mode
  ///////////////////////////////////////////////////////////////////////
  // crash detection and avoidance
  // PILOT mode is only active when robot is balancing
  if (safeMode != 4) {MainTask = 0; WiiOveride = false; return;}

  switch (MainTask) {
    case 0:
      // stationary task
      if ((Int34RPM > 0) && (Int35RPM > 0)) {MainTask = 1; return;} // moving forward
      if (Range <= 100) {
        // reverse Y- demand to increase distance
        auto_byte = (received_mem & 0b11110011) | 0b00001000; WiiOveride = true;
      } else {WiiOveride = false;}
      break;
   case 1:
    // moving forward task
    if ((Int34RPM <= 0) && (Int35RPM <= 0)) {MainTask = 0; return;} // stopped or reversed
    // robot is moving forwards
    if (Range < 150) {
      // block out forward Y+ demand
      auto_byte = received_mem & 0b11111011;
      // apply forward Y+ demand
      auto_byte = auto_byte | 0b00001000;
      WiiOveride = true;
    } else {WiiOveride = false;}
    break;
  }
}

// --------------------------------------------------------------------------------

void MainPlayTask() {
  ///////////////////////////////////////////////////////////////////////
  // PLAY mode
  ///////////////////////////////////////////////////////////////////////
  // responds to user hand gestures by movement and expressions
}

// --------------------------------------------------------------------------------
