/*
 * Decompiled with CFR 0.152.
 */
import processing.core.PApplet;
import processing.core.PImage;
import processing.serial.Serial;

public class Proc_3Ch_Controller_00
extends PApplet {
    Serial usbPort;
    int BB = 255;
    int BG = 255;
    int BR = 255;
    int Ch_Cnt = 0;
    int comFlag = 0;
    int comListLength = 0;
    String comName = "";
    int comPnt = 0;
    String CopyData = "";
    String CR = "\r\n";
    String data = "";
    boolean data_loaded = false;
    boolean DFU = false;
    int drawFlag = 1;
    int Freq = 50;
    String Help$ = "";
    String HelpLast$ = "";
    PImage img;
    int index = 0;
    int interval = 20;
    int JoyX0 = 259;
    int JoyX1 = 656;
    int keyDwn = 0;
    boolean keySHIFT = false;
    int LastVal;
    int LF = 10;
    boolean Loaded = false;
    int mDwn = 0;
    int mB;
    int mON;
    int mX;
    int mXD;
    int mY;
    int memState;
    String msgCh = "0";
    String msgCOM = "None";
    String msgRx = "";
    String msgTx = "";
    boolean msRun = false;
    int msTimer = 0;
    int mXL;
    int mYL;
    int nextWiFims = 0;
    int nextMillis = 0;
    String Released$ = "09/07/2021";
    String Rx$ = "";
    int servoLast = 0;
    int servoLL = 50;
    int servoOE = 1;
    int servoTgt = 0;
    int servoUL = 600;
    int sliderDwn = 0;
    int speedTQ = 0;
    int TB = 0;
    int TG = 0;
    int TR = 0;
    String usbBuff = "";
    int usbLen = 0;
    String usbMsg = "";
    int WiFiInt = 20;
    int WiFiPW = 64;
    boolean[] Ch_En = new boolean[4];
    int[] JoyXval = new int[4];
    int[] servoVal = new int[4];
    int[] servoVLL = new int[4];
    int[] servoVUL = new int[4];

    public void setup() {
        this.mON = 0;
        this.ClearChEn();
        this.img = this.loadImage("3-Channel Controller.png");
        this.textSize(13.0f);
        this.LoadDefArrays();
        this.setXSlider();
        this.getCOMPort();
        Proc_3Ch_Controller_00.println((String)"Ready!");
        this.sendExpRq();
        this.Loaded = true;
    }

    public void draw() {
        if (this.msRun) {
            this.drawFlag = 1;
        }
        if (this.drawFlag > 0) {
            this.background(this.img);
            this.drawServoVal();
            this.drawLLMsg();
            this.drawULMsg();
            this.drawJoyX();
            this.drawCOMMsg();
            this.drawRxMsg();
            this.drawTxMsg();
            this.drawHelp();
            this.drawFlag = 0;
        }
        if (this.mON > 0) {
            this.drawMouseXY();
        }
        if (this.millis() >= this.nextWiFims) {
            this.nextWiFims += this.WiFiInt;
            if (this.nextWiFims < this.millis()) {
                this.nextWiFims = this.millis() + this.WiFiInt;
            }
            if (this.comFlag > 0) {
                this.usbPortOp();
            } else {
                this.usbBuff = "";
            }
        }
        if (this.millis() >= this.nextMillis) {
            this.nextMillis += this.interval;
            if (this.nextMillis < this.millis()) {
                this.nextMillis = this.millis() + this.interval;
            }
            if (this.mDwn > 0) {
                --this.mDwn;
                if (this.mDwn < 1) {
                    this.mDwn = 5;
                    this.mouseDown();
                }
            }
        }
    }

    public void keyPressed() {
        this.keyDwn = 1;
        if (this.keyCode == 16) {
            this.keySHIFT = true;
        }
        if (this.keyCode == 37) {
            this.decActiveSliders();
        }
        if (this.keyCode == 39) {
            this.incActiveSliders();
        }
    }

    public void keyReleased() {
        this.keyDwn = 0;
        this.keySHIFT = false;
    }

    public void mouseDragged() {
        this.mX = this.mouseX;
        this.mY = this.mouseY;
        if (this.mX < 780) {
            this.mDwn = 0;
        }
        if (this.sliderDwn > 0) {
            this.readXSlider(this.servoTgt);
        }
    }

    public void mouseDown() {
        if (this.sliderDwn == 1) {
            return;
        }
        if (this.mY >= 51 && this.mY <= 156) {
            if (this.mX < 61) {
                this.SetChEn();
                this.mDwn = 0;
            }
            if (this.mX >= 226 && this.mX < 243) {
                this.decXSlider();
            }
            if (this.mX > 672 && this.mX <= 687) {
                this.incXSlider();
            }
            if (this.mX > 139 && this.mX < 155) {
                this.setLLValDwn();
            }
            if (this.mX > 207 && this.mX < 223) {
                this.setLLValUp();
            }
            if (this.mX > 693 && this.mX < 709) {
                this.setULValDwn();
            }
            if (this.mX > 761 && this.mX < 777) {
                this.setULValUp();
            }
        }
    }

    public void mouseMoved() {
        this.mX = this.mouseX;
        this.mY = this.mouseY;
        this.Help_Message();
        if (this.mON > 0) {
            this.drawFlag = 1;
        }
    }

    public void mousePressed() {
        this.mX = this.mouseX;
        this.mY = this.mouseY;
        this.mB = this.mouseButton;
        this.mDwn = 25;
        this.cursor(12);
        if (this.mX < 50 && this.mY < 50) {
            if (this.mON < 1) {
                this.mON = 1;
            } else {
                this.mON = 0;
                this.drawFlag = 1;
            }
        }
        if (this.mY >= 8 && this.mY <= 42 && this.mX > 701 && this.mX < 772) {
            this.sendRESET();
        }
        if (this.mY >= 46 && this.mY <= 156) {
            this.servoTgt = (this.mY - 46) * 3 / 108;
            if (this.servoTgt > 2) {
                this.servoTgt = 2;
            }
            if (this.mX < 61) {
                this.toggleChEn();
                this.mDwn = 50;
            }
            if (this.mX > 139 && this.mX < 155) {
                this.setLLValDwn();
            }
            if (this.mX > 207 && this.mX < 223) {
                this.setLLValUp();
            }
            if (this.mX >= 226 && this.mX < 243) {
                this.decXSlider();
            }
            if (this.mX > 672 && this.mX <= 687) {
                this.incXSlider();
            }
            if (this.mX >= 243 && this.mX <= 672) {
                this.sliderDwn = 1;
                this.mXD = this.mX - this.JoyXval[this.servoTgt];
                this.readXSlider(this.servoTgt);
            }
            if (this.mX > 693 && this.mX < 709) {
                this.setULValDwn();
            }
            if (this.mX > 761 && this.mX < 777) {
                this.setULValUp();
            }
            if (this.mX > 160 && this.mX < 200) {
                this.setLL();
            }
            if (this.mX > 720 && this.mX < 755) {
                this.setUL();
            }
        }
        if (this.mX > 104 && this.mX < 180 && this.mY > 170 && this.mY < 198) {
            if (this.mouseButton == 37) {
                this.getCOMPort();
            } else if (this.mouseButton == 39) {
                this.closeCOMPort();
            }
        }
        if (this.mX >= 710 && this.mX <= 806 && this.mY >= 696 && this.mY <= 722) {
            this.sendExpRq();
        }
    }

    public void mouseReleased() {
        this.mX = this.mouseX;
        this.mY = this.mouseY;
        this.cursor(0);
        this.mDwn = 0;
        this.sliderDwn = 0;
        if (this.DFU) {
            this.drawFlag = 1;
            this.Help_Message();
            this.DFU = false;
        }
    }

    public void serialEvent(Serial usbPort) {
        this.nextWiFims = this.millis() + 10;
        this.Rx$ = usbPort.readString();
        Proc_3Ch_Controller_00.print((String)this.Rx$);
        this.data = String.valueOf(this.data) + this.Rx$;
        int RxLF = this.data.indexOf(this.LF);
        if (RxLF >= 0) {
            if (this.data.indexOf("#") == 0) {
                this.data = Proc_3Ch_Controller_00.trim((String)this.data);
                if (this.data.indexOf("L") == 1) {
                    this.data = this.data.substring(3);
                    int zS = 0;
                    while (zS < 3) {
                        int zI = this.data.indexOf(",");
                        this.servoVLL[zS] = PApplet.parseInt((String)this.data.substring(0, zI));
                        this.data = this.data.substring(zI + 1);
                        ++zS;
                    }
                    this.data = "";
                    Proc_3Ch_Controller_00.println((String)"LL[] array data loaded");
                    this.msgRx = "";
                } else if (this.data.indexOf("R") == 1) {
                    this.data = this.data.substring(3);
                    int zS = 0;
                    while (zS < 3) {
                        int zI = this.data.indexOf(",");
                        this.servoVal[zS] = PApplet.parseInt((String)this.data.substring(0, zI));
                        this.data = this.data.substring(zI + 1);
                        ++zS;
                    }
                    this.data = "";
                    Proc_3Ch_Controller_00.println((String)"RV[] array data loaded");
                    this.msgRx = "";
                } else if (this.data.indexOf("U") == 1) {
                    this.data = this.data.substring(3);
                    int zS = 0;
                    while (zS < 15) {
                        int zI = this.data.indexOf(",");
                        this.servoVUL[zS] = PApplet.parseInt((String)this.data.substring(0, zI));
                        this.data = this.data.substring(zI + 1);
                        ++zS;
                    }
                    this.data = "";
                    Proc_3Ch_Controller_00.println((String)"UL[] array data loaded");
                    this.data_loaded = true;
                    this.ClearChEn();
                    this.servoOE = 1;
                    this.setXSlider();
                    this.msgRx = "Ready";
                } else {
                    this.msgRx = "ERROR - loading data";
                }
            } else {
                this.msgRx = this.data;
                if (this.data.length() > 20) {
                    this.msgRx = this.data.substring(0, 20);
                }
            }
            this.data = "";
            this.drawFlag = 1;
        }
    }

    public void centreJoyX() {
        this.servoVal[this.servoTgt] = this.servoVLL[this.servoTgt] + (this.servoVUL[this.servoTgt] - this.servoVLL[this.servoTgt]) / 2;
        this.setSliderX();
        this.drawFlag = 1;
    }

    public void centreServo() {
        this.centreJoyX();
        this.servoLast = this.servoVal[this.servoTgt];
        this.msgTx = "SV" + Proc_3Ch_Controller_00.str((int)this.servoVal[this.servoTgt]) + ".";
        this.usbPortWrite(this.msgTx);
    }

    public void ClearChEn() {
        int zC = 0;
        while (zC < 3) {
            this.Ch_En[zC] = false;
            ++zC;
        }
        this.Ch_Cnt = 0;
    }

    public void closeCOMPort() {
        if (this.comFlag > 0) {
            this.usbPort.clear();
            this.usbPort.stop();
            this.comFlag = 0;
            this.msgCOM = "----";
            this.drawFlag = 1;
            this.msgTx = "COM Port Closed";
            Proc_3Ch_Controller_00.println((String)this.msgTx);
            this.servoOE = 1;
            this.ClearChEn();
        }
    }

    public void countChannels() {
        this.Ch_Cnt = 0;
        int zC = 0;
        while (zC < 3) {
            if (this.Ch_En[zC]) {
                ++this.Ch_Cnt;
            }
            ++zC;
        }
    }

    public void decActiveSliders() {
        int zservoTgt = this.servoTgt;
        this.servoTgt = 0;
        while (this.servoTgt < 3) {
            if (this.Ch_En[this.servoTgt]) {
                this.decXSlider();
            }
            ++this.servoTgt;
        }
        this.servoTgt = zservoTgt;
    }

    public void decXSlider() {
        if (this.comFlag < 1) {
            return;
        }
        if (this.servoVal[this.servoTgt] > this.servoVLL[this.servoTgt]) {
            this.servoLast = this.servoVal[this.servoTgt];
            if (this.keySHIFT) {
                int n = this.servoTgt;
                this.servoVal[n] = this.servoVal[n] - 5;
            } else {
                int n = this.servoTgt;
                this.servoVal[n] = this.servoVal[n] - 1;
            }
            if (this.servoVal[this.servoTgt] < this.servoVLL[this.servoTgt]) {
                this.servoVal[this.servoTgt] = this.servoVLL[this.servoTgt];
            }
            this.setXSlider();
            this.msgTx = "ST" + Proc_3Ch_Controller_00.str((int)this.servoTgt) + "." + "SV" + Proc_3Ch_Controller_00.str((int)this.servoVal[this.servoTgt]) + ".";
            if (this.Ch_En[this.servoTgt]) {
                this.usbPortWrite(this.msgTx);
            }
            this.drawFlag = 1;
        }
    }

    public void drawCOMMsg() {
        if (this.comFlag < 1) {
            this.TR = 255;
        }
        this.drawTxtCtrField(this.msgCOM, 142, 177);
        this.TR = 0;
    }

    public void drawHelp() {
        this.TR = 0;
        this.TG = 0;
        this.TB = 255;
        this.drawTxtCtrField(this.Help$, 408, 208);
    }

    public void drawJoyX() {
        if (this.comFlag < 1) {
            return;
        }
        int zXw = 16;
        this.stroke(0.0f, 0.0f, 0.0f);
        this.strokeWeight(2.0f);
        if (this.Ch_En[0]) {
            this.fill(255.0f, 100.0f, 100.0f);
        } else {
            this.fill(255.0f, 255.0f, 255.0f);
        }
        this.rect(this.JoyXval[0] - zXw, 49.0f, zXw + zXw, 30.0f);
        if (this.Ch_En[1]) {
            this.fill(255.0f, 100.0f, 100.0f);
        } else {
            this.fill(255.0f, 255.0f, 255.0f);
        }
        this.rect(this.JoyXval[1] - zXw, 87.0f, zXw + zXw, 30.0f);
        if (this.Ch_En[2]) {
            this.fill(255.0f, 100.0f, 100.0f);
        } else {
            this.fill(255.0f, 255.0f, 255.0f);
        }
        this.rect(this.JoyXval[2] - zXw, 125.0f, zXw + zXw, 31.0f);
    }

    public void drawLLMsg() {
        if (this.comFlag < 1) {
            return;
        }
        int zX = 182;
        this.drawTxtCtrField("       ", zX, 57);
        this.drawTxtCtrField(Proc_3Ch_Controller_00.str((int)this.servoVLL[0]), zX, 57);
        this.drawTxtCtrField("       ", zX, 95);
        this.drawTxtCtrField(Proc_3Ch_Controller_00.str((int)this.servoVLL[1]), zX, 95);
        this.drawTxtCtrField("       ", zX, 134);
        this.drawTxtCtrField(Proc_3Ch_Controller_00.str((int)this.servoVLL[2]), zX, 134);
    }

    public void drawMouseXY() {
        if (this.mX != this.mXL || this.mY != this.mYL) {
            this.stroke(255.0f, 0.0f, 0.0f, 128.0f);
            this.strokeWeight(1.0f);
            this.line(0.0f, this.mY, 823.0f, this.mY);
            this.line(this.mX, 0.0f, this.mX, 731.0f);
            int zX = this.mX > 412 ? this.mX - 58 : this.mX + 8;
            int zY = this.mY > 380 ? this.mY - 38 : this.mY + 8;
            this.stroke(0.0f, 0.0f, 0.0f);
            this.fill(255.0f, 255.0f, 255.0f);
            this.rect(zX, zY, 50.0f, 30.0f);
            this.fill(0.0f, 0.0f, 0.0f);
            this.text("X=" + this.mX, zX + 4, zY + 13);
            this.text("Y=" + this.mY, zX + 4, zY + 27);
            this.mXL = this.mX;
            this.mYL = this.mY;
        }
    }

    public void drawRxMsg() {
        this.drawTxtField("                                             ", 242, 672);
        this.drawTxtField(this.msgRx, 242, 177);
    }

    public void drawServoVal() {
        if (this.comFlag < 1) {
            return;
        }
        int zX = 82;
        String zSV$ = "";
        zSV$ = Proc_3Ch_Controller_00.str((int)this.servoVal[0]);
        this.drawTxtField("       ", zX, 57);
        this.drawTxtField(zSV$, zX, 57);
        zSV$ = Proc_3Ch_Controller_00.str((int)this.servoVal[1]);
        this.drawTxtField("       ", zX, 95);
        this.drawTxtField(zSV$, zX, 95);
        zSV$ = Proc_3Ch_Controller_00.str((int)this.servoVal[2]);
        this.drawTxtField("       ", zX, 134);
        this.drawTxtField(zSV$, zX, 134);
    }

    public void drawTxtCtrField(String zM, int zX, int zY) {
        this.stroke(this.BR, this.BG, this.BB);
        this.fill(this.BR, this.BG, this.BB);
        this.rect(zX -= (int)(this.textWidth(zM) / 2.0f), zY, this.textWidth(zM), 15.0f);
        this.fill(this.TR, this.TG, this.TB);
        this.text(zM, zX, zY + 12);
    }

    public void drawTxMsg() {
        this.drawTxtField("                                       ", 498, 672);
        this.drawTxtField(this.msgTx, 498, 177);
    }

    public void drawTxtField(String zM, int zX, int zY) {
        this.stroke(242.0f, 242.0f, 242.0f);
        this.fill(242.0f, 242.0f, 242.0f);
        this.rect(zX, zY, 8.0f + this.textWidth(zM), 14.0f);
        this.fill(this.TR, this.TG, this.TB);
        this.text(zM, zX + 4, zY + 12);
    }

    public void drawULMsg() {
        if (this.comFlag < 1) {
            return;
        }
        int zX = 738;
        this.drawTxtCtrField("       ", zX, 57);
        this.drawTxtCtrField(Proc_3Ch_Controller_00.str((int)this.servoVUL[0]), zX, 57);
        this.drawTxtCtrField("       ", zX, 95);
        this.drawTxtCtrField(Proc_3Ch_Controller_00.str((int)this.servoVUL[1]), zX, 95);
        this.drawTxtCtrField("       ", zX, 134);
        this.drawTxtCtrField(Proc_3Ch_Controller_00.str((int)this.servoVUL[2]), zX, 134);
    }

    public void exit() {
        this.usbPortWrite("XX.");
        this.delay(20);
        super.exit();
    }

    public void getCOMPort() {
        if (this.comFlag > 0) {
            this.closeCOMPort();
            this.delay(100);
        }
        this.comListLength = Serial.list().length;
        if (this.comListLength > 0) {
            ++this.comPnt;
            if (this.comPnt >= this.comListLength) {
                this.comPnt = 0;
            }
            this.comName = Serial.list()[this.comPnt];
            Proc_3Ch_Controller_00.println((String)this.comName);
            try {
                this.usbPort = new Serial((PApplet)this, this.comName, 115200);
                this.comFlag = 1;
                this.msgCOM = this.comName;
                this.msgTx = "USB Connected";
                Proc_3Ch_Controller_00.println((String)this.msgTx);
            }
            catch (Exception exception) {
                this.comFlag = 0;
                this.msgCOM = "-Error-";
            }
        } else {
            this.comFlag = 0;
            this.msgCOM = "- NA -";
        }
        this.drawFlag = 1;
    }

    public void incActiveSliders() {
        int zservoTgt = this.servoTgt;
        this.servoTgt = 0;
        while (this.servoTgt < 4) {
            if (this.Ch_En[this.servoTgt]) {
                this.incXSlider();
            }
            ++this.servoTgt;
        }
        this.servoTgt = zservoTgt;
    }

    public void incXSlider() {
        if (this.comFlag < 1) {
            return;
        }
        if (this.servoVal[this.servoTgt] < this.servoVUL[this.servoTgt]) {
            this.servoLast = this.servoVal[this.servoTgt];
            if (this.keySHIFT) {
                int n = this.servoTgt;
                this.servoVal[n] = this.servoVal[n] + 5;
            } else {
                int n = this.servoTgt;
                this.servoVal[n] = this.servoVal[n] + 1;
            }
            if (this.servoVal[this.servoTgt] > this.servoVUL[this.servoTgt]) {
                this.servoVal[this.servoTgt] = this.servoVUL[this.servoTgt];
            }
            this.setXSlider();
            this.msgTx = "ST" + Proc_3Ch_Controller_00.str((int)this.servoTgt) + "." + "SV" + Proc_3Ch_Controller_00.str((int)this.servoVal[this.servoTgt]) + ".";
            if (this.Ch_En[this.servoTgt]) {
                this.usbPortWrite(this.msgTx);
            }
            this.drawFlag = 1;
        }
    }

    public void LoadDefArrays() {
        this.servoVal[0] = 1500;
        this.servoVLL[0] = 600;
        this.servoVUL[0] = 2400;
        this.servoVal[1] = 0;
        this.servoVLL[1] = -255;
        this.servoVUL[1] = 255;
        this.servoVal[2] = 0;
        this.servoVLL[2] = -255;
        this.servoVUL[2] = 255;
    }

    public void readXSlider(int zS) {
        if (this.comFlag < 1) {
            return;
        }
        this.servoLast = this.servoVal[zS];
        this.JoyXval[zS] = this.mX - this.mXD;
        this.JoyXval[zS] = Proc_3Ch_Controller_00.max((int)this.JoyXval[zS], (int)this.JoyX0);
        this.JoyXval[zS] = Proc_3Ch_Controller_00.min((int)this.JoyXval[zS], (int)this.JoyX1);
        this.servoVal[zS] = this.servoVLL[zS] + (this.JoyXval[zS] - this.JoyX0) * (this.servoVUL[this.servoTgt] - this.servoVLL[this.servoTgt]) / (this.JoyX1 - this.JoyX0);
        this.servoVal[zS] = Proc_3Ch_Controller_00.max((int)this.servoVal[zS], (int)this.servoVLL[zS]);
        this.servoVal[zS] = Proc_3Ch_Controller_00.min((int)this.servoVal[zS], (int)this.servoVUL[zS]);
        if (this.servoLast != this.servoVal[zS]) {
            this.servoLast = this.servoVal[zS];
            this.msgTx = "ST" + Proc_3Ch_Controller_00.str((int)zS) + "." + "SV" + Proc_3Ch_Controller_00.str((int)this.servoVal[zS]) + ".";
            if (this.Ch_En[zS]) {
                this.usbPortWrite(this.msgTx);
            }
            this.drawFlag = 1;
        }
    }

    public void sendButton(String zS) {
        if (this.comFlag < 1) {
            return;
        }
        this.msgTx = zS;
        this.usbPortWrite(this.msgTx);
        this.drawFlag = 1;
    }

    public void sendExpRq() {
        this.msgTx = "SE.";
        this.usbPortWrite(this.msgTx);
        this.drawFlag = 1;
    }

    public void sendRESET() {
        this.servoOE = 1;
        this.ClearChEn();
        this.LoadDefArrays();
        this.setXSlider();
        this.msgTx = "!";
        this.usbPortWrite(this.msgTx);
        this.drawFlag = 1;
    }

    public void sendServoVal() {
        this.servoLast = this.servoVal[this.servoTgt];
        this.msgTx = "ST" + Proc_3Ch_Controller_00.str((int)this.servoTgt) + "." + "SV" + Proc_3Ch_Controller_00.str((int)this.servoVal[this.servoTgt]) + ".";
        if (this.Ch_En[this.servoTgt]) {
            this.usbPortWrite(this.msgTx);
        }
        this.drawFlag = 1;
    }

    public void SetChEn() {
        if (this.comFlag < 1) {
            return;
        }
        int zS = this.servoTgt;
        this.servoTgt = 0;
        while (this.servoTgt < 3) {
            this.Ch_En[this.servoTgt] = this.Ch_En[zS];
            this.sendServoVal();
            ++this.servoTgt;
        }
        this.servoTgt = zS;
        this.drawFlag = 1;
        this.countChannels();
    }

    public void setLL() {
        if (this.comFlag < 1) {
            return;
        }
        this.LastVal = this.servoVLL[this.servoTgt];
        if (this.mB == 37) {
            this.servoVLL[this.servoTgt] = this.servoVal[this.servoTgt];
            if (this.servoVLL[this.servoTgt] >= this.servoVUL[this.servoTgt]) {
                int n = this.servoTgt;
                this.servoVLL[n] = this.servoVLL[n] - 1;
            }
        } else {
            this.servoVLL[this.servoTgt] = this.servoLL;
        }
        this.setXSlider();
        this.drawFlag = 1;
        this.msgTx = "SL" + Proc_3Ch_Controller_00.str((int)this.servoVLL[this.servoTgt]) + ".";
        this.usbPortWrite(this.msgTx);
    }

    public void setLLValDwn() {
        if (this.comFlag < 1) {
            return;
        }
        int zLL = 400;
        if (this.servoTgt > 0) {
            zLL = -255;
        }
        if (this.servoVLL[this.servoTgt] > zLL) {
            int n = this.servoTgt;
            this.servoVLL[n] = this.servoVLL[n] - 1;
            if (this.keySHIFT) {
                int n2 = this.servoTgt;
                this.servoVLL[n2] = this.servoVLL[n2] - 5;
            } else {
                int n3 = this.servoTgt;
                this.servoVLL[n3] = this.servoVLL[n3] - 1;
            }
            if (this.servoVLL[this.servoTgt] < zLL) {
                this.servoVLL[this.servoTgt] = zLL;
            }
            this.setXSlider();
            this.drawFlag = 1;
            this.msgTx = "SL" + Proc_3Ch_Controller_00.str((int)this.servoVLL[this.servoTgt]) + ".";
            this.usbPortWrite(this.msgTx);
        }
    }

    public void setLLValUp() {
        if (this.comFlag < 1) {
            return;
        }
        int zUL = 2400;
        if (this.servoTgt > 0) {
            zUL = 255;
        }
        if (this.servoVLL[this.servoTgt] < zUL) {
            if (this.keySHIFT) {
                int n = this.servoTgt;
                this.servoVLL[n] = this.servoVLL[n] + 5;
            } else {
                int n = this.servoTgt;
                this.servoVLL[n] = this.servoVLL[n] + 1;
            }
            if (this.servoVLL[this.servoTgt] > zUL) {
                this.servoVLL[this.servoTgt] = zUL;
            }
            if (this.servoVLL[this.servoTgt] >= this.servoVUL[this.servoTgt]) {
                int n = this.servoTgt;
                this.servoVUL[n] = this.servoVUL[n] + 1;
            }
            if (this.servoVal[this.servoTgt] < this.servoVLL[this.servoTgt]) {
                this.servoVal[this.servoTgt] = this.servoVLL[this.servoTgt];
            }
            this.setXSlider();
            this.drawFlag = 1;
            this.msgTx = "SL" + Proc_3Ch_Controller_00.str((int)this.servoVLL[this.servoTgt]) + ".";
            this.usbPortWrite(this.msgTx);
        }
    }

    public void setSliderX() {
        if (this.comFlag < 1 && this.Loaded) {
            return;
        }
        int zX0 = 259;
        int zX1 = 655;
        int zSV = this.servoVal[this.servoTgt];
        this.JoyXval[this.servoTgt] = zX0 + (zSV - this.servoVLL[this.servoTgt]) * (zX1 - zX0) / (this.servoVUL[this.servoTgt] - this.servoVLL[this.servoTgt]);
        this.drawFlag = 1;
    }

    public void setUL() {
        if (this.comFlag < 1) {
            return;
        }
        this.LastVal = this.servoVUL[this.servoTgt];
        if (this.mB == 37) {
            this.servoVUL[this.servoTgt] = this.servoVal[this.servoTgt];
            if (this.servoVUL[this.servoTgt] <= this.servoVLL[this.servoTgt]) {
                int n = this.servoTgt;
                this.servoVUL[n] = this.servoVUL[n] + 1;
            }
        } else {
            this.servoVUL[this.servoTgt] = this.servoUL;
        }
        this.setXSlider();
        this.drawFlag = 1;
        this.msgTx = "SU" + Proc_3Ch_Controller_00.str((int)this.servoVUL[this.servoTgt]) + ".";
        this.usbPortWrite(this.msgTx);
    }

    public void setULValDwn() {
        if (this.comFlag < 1) {
            return;
        }
        int zLL = 400;
        if (this.servoTgt > 0) {
            zLL = -255;
        }
        if (this.servoVUL[this.servoTgt] > zLL) {
            if (this.keySHIFT) {
                int n = this.servoTgt;
                this.servoVUL[n] = this.servoVUL[n] - 5;
            } else {
                int n = this.servoTgt;
                this.servoVUL[n] = this.servoVUL[n] - 1;
            }
            if (this.servoVUL[this.servoTgt] < zLL) {
                this.servoVLL[this.servoTgt] = zLL;
            }
            if (this.servoVUL[this.servoTgt] <= this.servoVLL[this.servoTgt]) {
                int n = this.servoTgt;
                this.servoVLL[n] = this.servoVLL[n] - 1;
            }
            if (this.servoVal[this.servoTgt] > this.servoVUL[this.servoTgt]) {
                this.servoVal[this.servoTgt] = this.servoVUL[this.servoTgt];
            }
            this.setXSlider();
            this.drawFlag = 1;
            this.msgTx = "SU" + Proc_3Ch_Controller_00.str((int)this.servoVUL[this.servoTgt]) + ".";
            this.usbPortWrite(this.msgTx);
        }
    }

    public void setULValUp() {
        if (this.comFlag < 1) {
            return;
        }
        int zUL = 2400;
        if (this.servoTgt > 0) {
            zUL = 255;
        }
        if (this.servoVUL[this.servoTgt] < zUL) {
            if (this.keySHIFT) {
                int n = this.servoTgt;
                this.servoVUL[n] = this.servoVUL[n] + 5;
            } else {
                int n = this.servoTgt;
                this.servoVUL[n] = this.servoVUL[n] + 1;
            }
            if (this.servoVUL[this.servoTgt] > zUL) {
                this.servoVUL[this.servoTgt] = zUL;
            }
            this.setXSlider();
            this.drawFlag = 1;
            this.msgTx = "SU" + Proc_3Ch_Controller_00.str((int)this.servoVUL[this.servoTgt]) + ".";
            this.usbPortWrite(this.msgTx);
        }
    }

    public void setXSlider() {
        if (this.comFlag < 1 && this.Loaded) {
            return;
        }
        int zX0 = 259;
        int zX1 = 655;
        int zS = 0;
        while (zS < 3) {
            this.JoyXval[zS] = zX0 + (this.servoVal[zS] - this.servoVLL[zS]) * (zX1 - zX0) / (this.servoVUL[zS] - this.servoVLL[zS]);
            ++zS;
        }
        this.drawFlag = 1;
    }

    public void toggleChEn() {
        if (this.comFlag < 1) {
            return;
        }
        this.Ch_En[this.servoTgt] = !this.Ch_En[this.servoTgt];
        this.msgTx = this.Ch_En[this.servoTgt] ? "ST" + Proc_3Ch_Controller_00.str((int)this.servoTgt) + ".SV" + Proc_3Ch_Controller_00.str((int)this.servoVal[this.servoTgt]) + "." : "SD.";
        this.usbPortWrite(this.msgTx);
        this.drawFlag = 1;
    }

    public void toggleMsTimer() {
        if (this.msRun) {
            this.msRun = false;
            this.msTimer = this.millis() - this.msTimer;
        } else {
            this.msRun = true;
            this.msTimer = this.millis();
        }
        this.DFU = true;
    }

    public void usbPortOp() {
        this.usbLen = this.usbBuff.length();
        if (this.usbLen < 1) {
            return;
        }
        if (this.usbLen <= this.WiFiPW) {
            this.usbPort.write(this.usbBuff);
            this.usbBuff = "";
            this.usbLen = 0;
        } else {
            this.usbPort.write(this.usbBuff.substring(0, this.WiFiPW));
            this.usbBuff = this.usbBuff.substring(this.WiFiPW, this.usbBuff.length());
            this.usbLen = this.usbBuff.length();
        }
    }

    public void usbPortWrite(String zmsg) {
        this.usbBuff = this.comFlag > 0 ? String.valueOf(this.usbBuff) + zmsg : "";
    }

    public void Help_Message() {
        this.Help$ = "-";
        if (this.mY >= 8 && this.mY <= 42 && this.mX > 701 && this.mX < 772) {
            this.Help$ = "Click to send RESET to micro.";
        }
        if (this.mY >= 46 && this.mY <= 154) {
            int zCh = (this.mY - 46) * 3 / 108;
            if (zCh > 2) {
                zCh = 2;
            }
            if (zCh >= 0) {
                if (this.mX < 61) {
                    this.Help$ = "Click to toggle channel " + Proc_3Ch_Controller_00.str((int)zCh) + " enable.";
                }
                if (this.mX >= 65 && this.mX <= 132) {
                    this.Help$ = "Channel " + Proc_3Ch_Controller_00.str((int)zCh) + " slider value.";
                }
                if (this.mX > 139 && this.mX < 155) {
                    this.Help$ = "Click to reduce channel " + Proc_3Ch_Controller_00.str((int)zCh) + " lower limit.";
                }
                if (this.mX > 207 && this.mX < 223) {
                    this.Help$ = "Click to increase channel " + Proc_3Ch_Controller_00.str((int)zCh) + " lower limit.";
                }
                if (this.mX >= 226 && this.mX < 243) {
                    this.Help$ = "Click to reduce channel " + Proc_3Ch_Controller_00.str((int)zCh) + " value.";
                }
                if (this.mX > 672 && this.mX <= 687) {
                    this.Help$ = "Click to increase channel " + Proc_3Ch_Controller_00.str((int)zCh) + " value.";
                }
                if (this.mX >= 243 && this.mX <= 672) {
                    this.Help$ = "Click and drag slider to adjust channel " + Proc_3Ch_Controller_00.str((int)zCh) + " value.";
                }
                if (this.mX > 693 && this.mX < 709) {
                    this.Help$ = "Click to reduce channel " + Proc_3Ch_Controller_00.str((int)zCh) + " upper limit.";
                }
                if (this.mX > 761 && this.mX < 777) {
                    this.Help$ = "Click to increase channel " + Proc_3Ch_Controller_00.str((int)zCh) + " upper limit.";
                }
                if (this.mX > 154 && this.mX < 208) {
                    this.Help$ = "Channel " + Proc_3Ch_Controller_00.str((int)zCh) + " lower limit. Click to set from slider.";
                }
                if (this.mX > 708 && this.mX < 762) {
                    this.Help$ = "Channel " + Proc_3Ch_Controller_00.str((int)zCh) + " upper limit. Click to set from slider.";
                }
            }
        }
        if (this.mY >= 170 && this.mY <= 196) {
            if (this.mX >= 105 && this.mX <= 180) {
                this.Help$ = this.comFlag < 1 ? "USB port is disconnected. Click-left to connect." : "USB port is connected. Click-right to disconnect.";
            }
            if (this.mX >= 235 && this.mX <= 439) {
                this.Help$ = "Messages received from USB port.";
            }
            if (this.mX >= 494 && this.mX <= 682) {
                this.Help$ = "Messages sent to the USB port.";
            }
        }
        if (this.mY >= 696 && this.mY <= 722) {
            if (this.mX >= 105 && this.mX <= 705) {
                this.Help$ = "Hello";
            }
            if (this.mX >= 710 && this.mX <= 806) {
                this.Help$ = "Author: TechKnowTone     Released: " + this.Released$;
            }
        }
        if (!this.Help$.equals(this.HelpLast$)) {
            this.HelpLast$ = this.Help$;
            this.drawFlag = 1;
        }
    }

    public void settings() {
        this.size(824, 240);
    }

    public static void main(String[] passedArgs) {
        String[] appletArgs = new String[]{"Proc_3Ch_Controller_00"};
        if (passedArgs != null) {
            PApplet.main((String[])Proc_3Ch_Controller_00.concat((String[])appletArgs, (String[])passedArgs));
        } else {
            PApplet.main((String[])appletArgs);
        }
    }
}

